/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.text;

import icyllis.modernui.graphics.font.FontMetricsInt;
import icyllis.modernui.text.LineBreaker;
import icyllis.modernui.text.MeasuredParagraph;
import icyllis.modernui.text.PrecomputedText;
import icyllis.modernui.text.Spanned;
import icyllis.modernui.text.TextDirectionHeuristic;
import icyllis.modernui.text.TextDirectionHeuristics;
import icyllis.modernui.text.TextLayout;
import icyllis.modernui.text.TextPaint;
import icyllis.modernui.util.Pool;
import icyllis.modernui.util.Pools;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StaticLayout
extends TextLayout {
    private static final int DEFAULT_MAX_LINE_HEIGHT = -1;
    private static final int COLUMNS_NORMAL = 5;
    private static final int COLUMNS_ELLIPSIZE = 7;
    private static final int START = 0;
    private static final int DIR = 0;
    private static final int TAB = 0;
    private static final int TOP = 1;
    private static final int DESCENT = 2;
    private static final int EXTRA = 3;
    private static final int HYPHEN = 4;
    private static final int ELLIPSIS_START = 5;
    private static final int ELLIPSIS_COUNT = 6;
    private static final int START_MASK = 0x1FFFFFFF;
    private static final int DIR_SHIFT = 30;
    private static final int TAB_MASK = 0x20000000;
    private int mLineCount;
    private int mTopPadding;
    private int mBottomPadding;
    private final int mColumns;
    private int mEllipsizedWidth;
    private boolean mEllipsized;
    private int mMaxLineHeight = -1;
    private int[] mLines;
    private TextLayout.Directions[] mLineDirections;
    private int mMaximumVisibleLineCount = Integer.MAX_VALUE;
    @Nullable
    private int[] mLeftIndents;
    @Nullable
    private int[] mRightIndents;

    StaticLayout(@Nullable CharSequence text) {
        this.mColumns = 7;
    }

    private StaticLayout(Builder b) {
        this.mColumns = 5;
        this.generate(b);
    }

    void generate(@Nonnull Builder b) {
        CharSequence source = b.mText;
        int bufStart = b.mStart;
        int bufEnd = b.mEnd;
        TextPaint paint = b.mPaint;
        int outerWidth = b.mWidth;
        TextDirectionHeuristic textDir = b.mTextDir;
        boolean fallbackLineSpacing = b.mFallbackLineSpacing;
        int lineBreakCapacity = 0;
        int[] breaks = null;
        float[] lineWidths = null;
        float[] ascents = null;
        float[] descents = null;
        boolean[] hasTabs = null;
        this.mLineCount = 0;
        int v = 0;
        FontMetricsInt fm = new FontMetricsInt();
        LineBreaker.ParagraphConstraints constraints = new LineBreaker.ParagraphConstraints();
        Spanned spanned = source instanceof Spanned ? (Spanned)source : null;
        PrecomputedText.ParagraphInfo[] paragraphInfo = PrecomputedText.createMeasuredParagraphs(paint, source, bufStart, bufEnd, textDir);
        int paraStart = 0;
        for (int paraIndex = 0; paraIndex < paragraphInfo.length; ++paraIndex) {
            int paraEnd = paragraphInfo[paraIndex].paragraphEnd;
            int firstWidth = outerWidth;
            int restWidth = outerWidth;
            if (spanned != null) {
                // empty if block
            }
            MeasuredParagraph measuredPara = paragraphInfo[paraIndex].measured;
            int[] spanEndCache = measuredPara.getSpanEndCache().elements();
            int[] fmCache = measuredPara.getFontMetrics().elements();
            constraints.setWidth(restWidth);
            constraints.setIndent(firstWidth);
            constraints.setTabStops(null, 20.0f);
            LineBreaker.Result res = LineBreaker.computeLineBreaks(measuredPara.getMeasuredText(), constraints, null, 0);
            int remainingLineCount = this.mMaximumVisibleLineCount - this.mLineCount;
            int breakCount = res.getLineCount();
            if (breakCount > lineBreakCapacity) {
                lineBreakCapacity = breakCount;
                breaks = new int[lineBreakCapacity];
                lineWidths = new float[lineBreakCapacity];
                ascents = new float[lineBreakCapacity];
                descents = new float[lineBreakCapacity];
                hasTabs = new boolean[lineBreakCapacity];
            }
            for (int i = 0; i < breakCount; ++i) {
                breaks[i] = res.getLineBreakOffset(i);
                lineWidths[i] = res.getLineWidth(i);
                ascents[i] = res.getLineAscent(i);
                descents[i] = res.getLineDescent(i);
                hasTabs[i] = res.hasLineTab(i);
            }
            boolean ellipsisMayBeApplied = false;
            if (0 < remainingLineCount && remainingLineCount < breakCount && ellipsisMayBeApplied) {
                float width = 0.0f;
                boolean hasTab = false;
                for (int i = remainingLineCount - 1; i < breakCount; ++i) {
                    if (i == breakCount - 1) {
                        width += lineWidths[i];
                    } else {
                        int j;
                        int n = j = i == 0 ? 0 : breaks[i - 1];
                        while (j < breaks[i]) {
                            width += measuredPara.getMeasuredText().mAdvances[j];
                            ++j;
                        }
                    }
                    hasTab |= hasTabs[i];
                }
                breaks[remainingLineCount - 1] = breaks[breakCount - 1];
                lineWidths[remainingLineCount - 1] = width;
                hasTabs[remainingLineCount - 1] = hasTab;
                breakCount = remainingLineCount;
            }
            int here = paraStart;
            int fmAscent = 0;
            int fmDescent = 0;
            int breakIndex = 0;
            int spanStart = paraStart;
            int spanIndex = 0;
            while (spanStart < paraEnd) {
                int spanEnd = spanEndCache[spanIndex];
                fm.mAscent = fmCache[spanIndex * 2];
                fm.mDescent = fmCache[spanIndex * 2 + 1];
                fmAscent = Math.max(fmAscent, fm.mAscent);
                fmDescent = Math.max(fmDescent, fm.mDescent);
                while (breakIndex < breakCount && paraStart + breaks[breakIndex] < spanStart) {
                    ++breakIndex;
                }
                while (breakIndex < breakCount && paraStart + breaks[breakIndex] <= spanEnd) {
                    int endPos = paraStart + breaks[breakIndex];
                    boolean moreChars = endPos < bufEnd;
                    int ascent = fallbackLineSpacing ? Math.max(fmAscent, Math.round(ascents[breakIndex])) : fmAscent;
                    int descent = fallbackLineSpacing ? Math.max(fmDescent, Math.round(descents[breakIndex])) : fmDescent;
                    v = this.out(v);
                    if (endPos < spanEnd) {
                        fmAscent = fm.mAscent;
                        fmDescent = fm.mDescent;
                    } else {
                        fmDescent = 0;
                        fmAscent = 0;
                    }
                    here = endPos;
                    ++breakIndex;
                    if (this.mLineCount < this.mMaximumVisibleLineCount || !this.mEllipsized) continue;
                    return;
                }
                spanStart = spanEnd;
                ++spanIndex;
            }
            if (paraEnd == bufEnd) break;
            paraStart = paraEnd;
        }
    }

    private int out(int v) {
        int j = this.mLineCount;
        int off = j * this.mColumns;
        int want = off + this.mColumns + 1;
        if (want >= this.mLines.length) {
            this.mLines = IntArrays.forceCapacity((int[])this.mLines, (int)want, (int)this.mLines.length);
        }
        if (j >= this.mLineDirections.length) {
            this.mLineDirections = (TextLayout.Directions[])ObjectArrays.forceCapacity((Object[])this.mLineDirections, (int)j, (int)this.mLineDirections.length);
        }
        int[] lines = this.mLines;
        return v;
    }

    public static final class Builder {
        private static final Pool<Builder> sPool = Pools.concurrent(3);
        private CharSequence mText;
        private int mStart;
        private int mEnd;
        private TextPaint mPaint;
        private int mWidth;
        private TextLayout.Alignment mAlignment;
        private TextDirectionHeuristic mTextDir;
        private boolean mFallbackLineSpacing;

        private Builder() {
        }

        @Nonnull
        public static Builder obtain(@Nonnull CharSequence source, int start, int end, @Nonnull TextPaint paint, int width) {
            Builder b = sPool.acquire();
            if (b == null) {
                b = new Builder();
            }
            b.mText = source;
            b.mStart = start;
            b.mEnd = end;
            b.mPaint = paint;
            b.mWidth = width;
            b.mAlignment = TextLayout.Alignment.ALIGN_NORMAL;
            b.mTextDir = TextDirectionHeuristics.FIRSTSTRONG_LTR;
            b.mFallbackLineSpacing = true;
            return b;
        }

        private void recycle() {
            this.release();
            sPool.release(this);
        }

        void release() {
            this.mText = null;
            this.mPaint = null;
        }

        @Nonnull
        Builder setText(@Nonnull CharSequence source, int start, int end) {
            this.mText = source;
            this.mStart = start;
            this.mEnd = end;
            return this;
        }

        @Nonnull
        Builder setPaint(@Nonnull TextPaint paint) {
            this.mPaint = paint;
            return this;
        }

        @Nonnull
        Builder setWidth(int width) {
            this.mWidth = width;
            return this;
        }

        @Nonnull
        public Builder setAlignment(@Nonnull TextLayout.Alignment alignment) {
            this.mAlignment = alignment;
            return this;
        }

        @Nonnull
        public Builder setTextDirection(@Nonnull TextDirectionHeuristic textDir) {
            this.mTextDir = textDir;
            return this;
        }

        @Nonnull
        public Builder setUseLineSpacingFromFallbacks(boolean useLineSpacingFromFallbacks) {
            this.mFallbackLineSpacing = useLineSpacingFromFallbacks;
            return this;
        }

        @Nonnull
        public StaticLayout build() {
            StaticLayout result = new StaticLayout(this);
            this.recycle();
            return result;
        }
    }
}

